/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.udp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.PacketMessageFactory;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPHeader;
import java.util.ArrayList;
import java.util.List;

public class UDPPacket
extends Packet {
    private UDPHeader mHeader;
    private IPacket mPayload;
    private List<Identifier> mIdentifiers;

    public UDPPacket(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getHeader().isValid()) {
            sb.append(this.getHeader());
        } else {
            sb.append("INVALID HEADER");
        }
        sb.append(" ").append(this.getPayload());
        return sb.toString();
    }

    @Override
    public UDPHeader getHeader() {
        if (this.mHeader == null) {
            this.mHeader = new UDPHeader(this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    @Override
    public IPacket getPayload() {
        if (this.mPayload == null && this.getHeader().isValid()) {
            this.mPayload = this.getHeader().isValid() ? PacketMessageFactory.createUDPPayload(this.getHeader().getSourcePort(), this.getHeader().getDestinationPort(), this.getMessage(), this.getOffset() + this.getHeader().getLength()) : new UnknownPacket(this.getMessage(), this.getOffset() + 64);
        }
        return this.mPayload;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getHeader().getSourcePort());
            this.mIdentifiers.add(this.getHeader().getDestinationPort());
            if (this.hasPayload()) {
                this.mIdentifiers.addAll(this.getPayload().getIdentifiers());
            }
        }
        return this.mIdentifiers;
    }
}

