/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.xcmp;

import java.util.Map;
import java.util.TreeMap;

public enum XCMPMessageType {
    NETWORK_FREQUENCY_FILE(2, "NETWORK FREQUENCY FILE"),
    UNKNOWN(-1, "UNKNOWN");

    private int mValue;
    private String mLabel;
    private static final Map<Integer, XCMPMessageType> LOOKUP_MAP;

    private XCMPMessageType(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mLabel;
    }

    public static XCMPMessageType fromValue(int value) {
        if (LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, XCMPMessageType>();
        for (XCMPMessageType type : XCMPMessageType.values()) {
            LOOKUP_MAP.put(type.getValue(), type);
        }
    }
}

