/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.xcmp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPMessageType;
import java.util.Collections;
import java.util.List;

public class XCMPHeader
extends Header {
    private static final int[] MESSAGE_TYPE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public XCMPHeader(BinaryMessage message, int offset) {
        super(message, offset);
    }

    public static XCMPMessageType getMessageType(BinaryMessage message, int offset) {
        return XCMPMessageType.fromValue(message.getInt(MESSAGE_TYPE, offset));
    }

    public XCMPMessageType getMessageType() {
        return XCMPHeader.getMessageType(this.getMessage(), this.getOffset());
    }

    public int getMessageTypeValue() {
        return this.getMessage().getInt(MESSAGE_TYPE, this.getOffset());
    }

    @Override
    public int getLength() {
        return 8;
    }

    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XCMP");
        if (this.getMessageType() != XCMPMessageType.UNKNOWN) {
            sb.append(" ").append((Object)this.getMessageType());
        } else {
            sb.append(" UNKNOWN FILE TYPE:").append(String.format("%02X", this.getMessageTypeValue()));
        }
        return sb.toString();
    }
}

