/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPDUType;
import java.util.List;

public abstract class ARSHeader
extends Header {
    private static final int[] LENGTH = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int HEADER_EXTENSION_FLAG = 16;
    private static final int ACKNOWLEDGEMENT_FLAG = 17;
    private static final int PRIORITY_FLAG = 18;
    private static final int CONTROL_USER_FLAG = 19;
    private static final int[] PDU_TYPE = new int[]{20, 21, 22, 23};

    public ARSHeader(BinaryMessage message, int offset) {
        super(message, offset);
    }

    private void checkValid() {
        this.setValid(this.getMessage().size() >= this.getOffset() + this.getLength() + this.getPayloadLength());
    }

    public ARSPDUType getPDUType() {
        return ARSHeader.getPDUType(this.getMessage(), this.getOffset());
    }

    public static ARSPDUType getPDUType(BinaryMessage message, int offset) {
        return ARSPDUType.fromValue(message.getInt(PDU_TYPE, offset));
    }

    public boolean hasHeaderExtension() {
        return this.getMessage().get(16 + this.getOffset());
    }

    public boolean isAcknowledge() {
        return this.getMessage().get(17 + this.getOffset());
    }

    public boolean isPriority() {
        return this.getMessage().get(18 + this.getOffset());
    }

    public boolean isControl() {
        return this.getMessage().get(19 + this.getOffset());
    }

    public int getPayloadLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    @Override
    public int getLength() {
        if (this.hasHeaderExtension()) {
            return 32;
        }
        return 24;
    }

    public abstract List<Identifier> getIdentifiers();
}

