/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.icmp;

import java.util.Map;
import java.util.TreeMap;

public enum ICMPTypeCode {
    ECHO_REPLY(0, 0, "ECHO REPLY"),
    DESTINATION_NETWORK_UNREACHABLE(3, 0, "DESTINATION NETWORK UNREACHABLE"),
    DESTINATION_HOST_UNREACHABLE(3, 1, "DESTINATION HOST UNREACHABLE"),
    DESTINATION_PROTOCOL_UNREACHABLE(3, 2, "DESTINATION PROTOCOL UNREACHABLE"),
    DESTINATION_PORT_UNREACHABLE(3, 3, "DESTINATION PORT UNREACHABLE"),
    FRAGMENTATION_REQUIRED(3, 4, "FRAGMENTATION REQUIRED"),
    SOURCE_ROUTE_FAILED(3, 5, "SOURCE ROUTE FAILED"),
    DESTINATION_NETWORK_UNKNOWN(3, 6, "DESTINATION NETWORK UNKNOWN"),
    DESTINATION_HOST_UNKNOWN(3, 7, "DESTINATION HOST UNKNOWN"),
    SOURCE_HOST_ISOLATED(3, 8, "SOURCE HOST ISOLATED"),
    NETWORK_ADMINISTRATIVELY_PROHIBITED(3, 9, "NETWORK ADMINISTRATIVELY PROHIBITED"),
    HOST_ADMINISTRATIVELY_PROHIBITED(3, 10, "HOST ADMINISTRATIVELY PROHIBITED"),
    NETWORK_UNREACHABLE_FOR_TOS(3, 11, "NETWORK UNREACHABLE FOR TOS"),
    HOST_UNREACHABLE_FOR_TOS(3, 12, "HOST UNREACHABLE FOR TOS"),
    COMMUNICATION_ADMINISTRATIVELY_PROHIBITED(3, 13, "COMMUNICATION ADMINISTRATIVELY PROHIBITED"),
    HOST_PRECEDENCE_VIOLATION(3, 14, "HOST PRECEDENCE VIOLATION"),
    PRECEDENCE_CUTOFF_IN_EFFECT(3, 15, "PRECEDENCE CUTOFF IN EFFECT"),
    REDIRECT_DATAGRAM_FOR_THE_NETWORK(5, 0, "REDIRECT DATAGRAM FOR THE NETWORK"),
    REDIRECT_DATAGRAM_FOR_THE_HOST(5, 1, "REDIRECT DATAGRAM FOR THE HOST"),
    REDIRECT_DATAGRAM_FOR_THE_TOS_AND_NETWORK(5, 2, "REDIRECT DATAGRAM FOR THE TOS & NETWORK"),
    REDIRECT_DATAGRAM_FOR_THE_TOS_AND_HOST(5, 3, "REDIRECT DATAGRAM FOR THE TOS & HOST"),
    ECHO_REQUEST(8, 0, "ECHO REQUEST"),
    ROUTER_ADVERTISEMENT(9, 0, "ROUTER ADVERTISEMENT"),
    ROUTER_SOLICITATION(10, 0, "ROUTER SOLICITATION"),
    TTL_EXPIRED_IN_TRANSIT(11, 0, "TTL EXPIRED IN TRANSIT"),
    FRAGMENT_REASSEMBLY_TIME_EXCEEDED(11, 1, "FRAGMENT REASSEMBLY TIME EXCEEDED"),
    IP_HEADER_ERROR_POINTER(12, 0, "IP HEADER ERROR - POINTER INDICATES ERROR"),
    IP_HEADER_ERROR_MISSING_OPTION(12, 1, "IP HEADER ERROR - MISSING REQUIRED OPTION"),
    IP_HEADER_ERROR_BAD_LENGTH(12, 2, "IP HEADER ERROR - BAD LENGTH"),
    TIMESTAMP(13, 0, "TIMESTAMP"),
    TIMESTAMP_REPLY(14, 0, "TIMESTAMP REPLY"),
    EXTENDED_ECHO_REQUEST(42, 0, "EXTENDED ECHO REQUEST"),
    EXTENDED_ECHO_REPLY_NO_ERROR(43, 0, "EXTENDED ECHO - NO ERROR"),
    EXTENDED_ECHO_REPLY_MALFORMED_QUERY(43, 1, "EXTENDED ECHO - MALFORMED QUERY"),
    EXTENDED_ECHO_REPLY_NO_INTERFACE(43, 2, "EXTENDED ECHO - NO SUCH INTERFACE"),
    EXTENDED_ECHO_REPLY_NO_TABLE(43, 3, "EXTENDED ECHO - NO SUCH TABLE ENTRY"),
    EXTENDED_ECHO_REPLY_MULTIPLE_INTERFACES(43, 4, "EXTENDED ECHO - MULTIPLE INTERFACES"),
    UNKNOWN(-1, -1, "UNKNOWN");

    private int mValue;
    private String mLabel;
    private static final Map<Integer, ICMPTypeCode> LOOKUP_MAP;

    private ICMPTypeCode(int type, int code, String label) {
        this.mValue = (type << 8) + code;
        this.mLabel = label;
    }

    public static ICMPTypeCode fromValue(int value) {
        if (LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, ICMPTypeCode>();
        for (ICMPTypeCode type : ICMPTypeCode.values()) {
            LOOKUP_MAP.put(type.getValue(), type);
        }
    }
}

