/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.icmp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.PacketMessageFactory;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.icmp.ICMPHeader;
import java.util.ArrayList;
import java.util.List;

public class ICMPPacket
extends Packet {
    private ICMPHeader mHeader;
    private IPacket mPayload;
    private List<Identifier> mIdentifiers;

    public ICMPPacket(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getHeader().isValid()) {
            sb.append(this.getHeader());
        } else {
            sb.append("INVALID HEADER");
        }
        sb.append(" PACKET:").append(this.getPayload());
        return sb.toString();
    }

    @Override
    public ICMPHeader getHeader() {
        if (this.mHeader == null) {
            this.mHeader = new ICMPHeader(this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    @Override
    public IPacket getPayload() {
        if (this.mPayload == null && this.getHeader().isValid()) {
            if (this.getHeader().isValid()) {
                int offset = this.getOffset();
                int headerLength = this.getHeader().getLength();
                int totalOffset = offset + headerLength;
                this.mPayload = PacketMessageFactory.create(this.getMessage(), this.getOffset() + this.getHeader().getLength());
            } else {
                this.mPayload = new UnknownPacket(this.getMessage(), this.getOffset() + this.getHeader().getLength());
            }
        }
        return this.mPayload;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasPayload()) {
                this.mIdentifiers.addAll(this.getPayload().getIdentifiers());
            }
        }
        return this.mIdentifiers;
    }
}

