/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.icmp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.icmp.ICMPTypeCode;

public class ICMPHeader
extends Header {
    private static final int[] TYPE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] CODE = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] TYPE_CODE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

    public ICMPHeader(BinaryMessage message, int offset) {
        super(message, offset);
        this.checkValid();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ICMPTypeCode typeCode = this.getTypeCode();
        if (typeCode != ICMPTypeCode.UNKNOWN) {
            sb.append("ICMP ").append((Object)typeCode);
        } else {
            sb.append("ICMP UNKNOWN TYPE CODE:").append(this.getTypeCodeValue());
        }
        return sb.toString();
    }

    public ICMPTypeCode getTypeCode() {
        return ICMPTypeCode.fromValue(this.getTypeCodeValue());
    }

    public int getTypeCodeValue() {
        return this.getMessage().getInt(TYPE_CODE, this.getOffset());
    }

    public int getType() {
        return this.getMessage().getInt(TYPE, this.getOffset());
    }

    public int getCode() {
        return this.getMessage().getInt(CODE, this.getOffset());
    }

    private void checkValid() {
        this.setValid(this.getMessage().size() >= this.getOffset() + this.getLength());
    }

    @Override
    public int getLength() {
        return 64;
    }
}

