/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sds;

import com.google.common.base.Joiner;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.IHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenFactory;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;
import java.util.ArrayList;
import java.util.List;

public class HyteraTokenHeader
implements IHeader {
    private static int[] TWO_BYTES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static int[] FOUR_BYTES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private CorrectedBinaryMessage mMessage;
    private List<HyteraToken> mParsedTokens = new ArrayList<HyteraToken>();

    public HyteraTokenHeader(CorrectedBinaryMessage message) {
        this.mMessage = message;
        this.parse();
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public int getLength() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HYTERA TOKEN HEADER: ").append(Joiner.on((String)",").join(this.getParsedTokens()));
        return sb.toString();
    }

    public boolean isSMSMessage() {
        return this.hasTokens(HyteraTokenType.TEXT_MESSAGE_SERVICE_HEADER, HyteraTokenType.ENCODING, HyteraTokenType.PAYLOAD);
    }

    public boolean isRRSMessage() {
        return this.hasTokens(HyteraTokenType.RADIO_REGISTRATION_SERVICE_HEADER, HyteraTokenType.ID_DESTINATION);
    }

    public boolean hasTokens(HyteraTokenType ... types) {
        boolean hasToken = true;
        for (HyteraTokenType type : types) {
            hasToken &= this.hasToken(type);
        }
        return hasToken;
    }

    public boolean hasToken(HyteraTokenType type) {
        return this.getTokenByType(type) != null;
    }

    public HyteraToken getTokenByType(HyteraTokenType type) {
        for (HyteraToken token : this.mParsedTokens) {
            if (token.getTokenType() != type) continue;
            return token;
        }
        return null;
    }

    public List<HyteraToken> getParsedTokens() {
        return this.mParsedTokens;
    }

    private void parse() {
        int offset = 0;
        while (offset < this.mMessage.length()) {
            int opcode = this.mMessage.getInt(TWO_BYTES, offset);
            int length = 16;
            HyteraTokenType token = HyteraTokenType.fromOpcode(opcode);
            if (token != HyteraTokenType.UNKNOWN) {
                if (token.isFixedLength()) {
                    length += token.getFieldLength() * 8;
                } else {
                    int contentLength = this.mMessage.getInt(TWO_BYTES, offset + length);
                    length += 16;
                    length += contentLength * 8;
                }
                HyteraToken field = HyteraTokenFactory.getField(token, this.mMessage.getSubMessage(offset, offset + length));
                offset += length;
                this.mParsedTokens.add(field);
                continue;
            }
            CorrectedBinaryMessage remainder = this.mMessage.getSubMessage(offset, this.mMessage.length() + 1);
            HyteraToken unknown = HyteraTokenFactory.getField(HyteraTokenType.UNKNOWN, remainder);
            this.mParsedTokens.add(unknown);
            offset = this.mMessage.length();
        }
    }
}

