/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sds;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.ipv4.IPV4Address;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;

public class DestinationId
extends HyteraToken {
    private static final int[] CONTENT_LENGTH = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int CONTENT_START = 32;
    private static final int[] ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};

    public DestinationId(CorrectedBinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DESTINATION:").append(this.getIdFormatted());
        return sb.toString();
    }

    public boolean isIp() {
        return this.getId() > 0xFFFFFF;
    }

    public int getContentLength() {
        return this.mMessage.getInt(CONTENT_LENGTH);
    }

    public int getId() {
        return this.mMessage.getInt(ID);
    }

    public String getIdFormatted() {
        if (this.isIp()) {
            return new IPV4Address(this.getId()).toString() + " [" + (this.getId() & 0xFFFFFF) + "]";
        }
        return String.valueOf(this.getId());
    }

    @Override
    HyteraTokenType getTokenType() {
        return HyteraTokenType.ID_DESTINATION;
    }
}

