/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import org.apache.commons.lang3.StringUtils;

public class ProgrammingCommandMessage
extends MCGPPacket {
    private static final int[] TARGET_UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMAND_NUMERATOR = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] AUTHENTICATION_CODE = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 56, 57, 58, 59, 60, 61, 62, 63, 48, 49, 50, 51, 52, 53, 54, 55, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] BLOCK_CODE = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BITMASK = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    private static final int DATA_BLOCK_START = 96;
    private static final int DATA_BLOCK_END = 224;
    private CellocatorRadioIdentifier mTargetRadioId;

    public ProgrammingCommandMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mTargetRadioId == null) {
            this.mTargetRadioId = CellocatorRadioIdentifier.createTo(this.getMessage().getInt(TARGET_UNIT_ID, this.getOffset()));
        }
        return this.mTargetRadioId;
    }

    public int getCommandNumerator() {
        return this.getMessage().getInt(COMMAND_NUMERATOR, this.getOffset());
    }

    public String getAuthenticationCode() {
        return Integer.toHexString(this.getMessage().getInt(AUTHENTICATION_CODE, this.getOffset())).toUpperCase();
    }

    public int getBlockCode() {
        return this.getMessage().getInt(BLOCK_CODE, this.getOffset());
    }

    public String getBitMask() {
        return StringUtils.leftPad((String)Integer.toHexString(this.getMessage().getInt(BITMASK, this.getOffset())).toUpperCase(), (int)4, (String)"0");
    }

    public String getDataBlock() {
        return this.getMessage().getSubMessage(96 + this.getOffset(), 224 + this.getOffset()).toHexString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR RADIO:");
        sb.append(this.getRadioId());
        sb.append(" PROGRAM SEQUENCE NUMBER:").append(this.getCommandNumerator());
        sb.append(" AUTH:").append(this.getAuthenticationCode());
        sb.append(" BLOCK:").append(this.getBlockCode());
        sb.append(" BITMASK:").append(this.getBitMask());
        sb.append(" DATA:").append(this.getDataBlock());
        return sb.toString();
    }
}

