/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

public class PacketControl {
    private static final int BIT_MASK_DIRECTION = 128;
    private static final int BIT_MASK_OUT_OF_SPACE = 64;
    private int mValue;

    public PacketControl(int value) {
        this.mValue = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" MODULAR PACKET ").append((Object)this.getDirection());
        if (this.isOutOfSpace()) {
            sb.append(" (MESSAGE EXCEEDED SPACE)");
        }
        return sb.toString();
    }

    public Direction getDirection() {
        return this.isSet(128) ? Direction.TO_UNIT : Direction.FROM_UNIT;
    }

    public boolean isOutOfSpace() {
        return this.isSet(64);
    }

    private boolean isSet(int bitMask) {
        return (this.mValue & bitMask) == bitMask;
    }

    public static enum Direction {
        TO_UNIT,
        FROM_UNIT;

    }
}

