/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.CommunicationControl;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import io.github.dsheirer.module.decode.ip.cellocator.ModularDataType;
import io.github.dsheirer.module.decode.ip.cellocator.PacketControl;

public class ModularResponseMessage
extends MCGPPacket {
    private static final int[] UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMUNICATION_CONTROL = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] MESSAGE_NUMERATOR = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] PACKET_CONTROL = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] TOTAL_MESSAGE_LENGTH = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SUB_DATA_1_MESSAGE_TYPE = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private CellocatorRadioIdentifier mRadioId;
    private CommunicationControl mCommunicationControl;
    private PacketControl mPacketControl;

    public ModularResponseMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    public static int getTotalMessageLength(BinaryMessage message, int offset) {
        return message.getInt(TOTAL_MESSAGE_LENGTH, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mRadioId == null) {
            int radioId = this.getMessage().getInt(UNIT_ID, this.getOffset());
            this.mRadioId = this.getPacketControl().getDirection() == PacketControl.Direction.FROM_UNIT ? CellocatorRadioIdentifier.createFrom(radioId) : CellocatorRadioIdentifier.createTo(radioId);
        }
        return this.mRadioId;
    }

    public PacketControl getPacketControl() {
        if (this.mPacketControl == null) {
            this.mPacketControl = new PacketControl(this.getMessage().getInt(PACKET_CONTROL, this.getOffset()));
        }
        return this.mPacketControl;
    }

    public CommunicationControl getCommunicationControl() {
        if (this.mCommunicationControl == null) {
            this.mCommunicationControl = new CommunicationControl(this.getMessage().getInt(COMMUNICATION_CONTROL, this.getOffset()));
        }
        return this.mCommunicationControl;
    }

    public int getMessageNumerator() {
        return this.getMessage().getInt(MESSAGE_NUMERATOR, this.getOffset());
    }

    public ModularDataType getModularDataType() {
        return ModularDataType.fromValue(this.getMessage().getInt(SUB_DATA_1_MESSAGE_TYPE, this.getOffset()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR RADIO:");
        if (this.getPacketControl().getDirection() == PacketControl.Direction.FROM_UNIT) {
            sb.append(" FROM:");
        } else {
            sb.append(" TO:");
        }
        sb.append(this.getRadioId());
        sb.append(" MODULAR TYPE:").append((Object)this.getModularDataType());
        sb.append(" MESSAGE NUMBER:").append(this.getMessageNumerator());
        return sb.toString();
    }
}

