/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import io.github.dsheirer.module.decode.ip.cellocator.ModularDataType;
import io.github.dsheirer.module.decode.ip.cellocator.PacketControl;

public class ModularRequestMessage
extends MCGPPacket {
    private static final int[] TARGET_UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMAND_NUMERATOR = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] PACKET_CONTROL = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] TOTAL_MESSAGE_LENGTH = new int[]{96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] SUB_DATA_1_MESSAGE_TYPE = new int[]{104, 105, 106, 107, 108, 109, 110, 111};
    private CellocatorRadioIdentifier mTargetRadioId;
    private PacketControl mPacketControl;

    public ModularRequestMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    public static int getTotalMessageLength(BinaryMessage message, int offset) {
        return message.getInt(TOTAL_MESSAGE_LENGTH, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mTargetRadioId == null) {
            int radioId = this.getMessage().getInt(TARGET_UNIT_ID, this.getOffset());
            this.mTargetRadioId = CellocatorRadioIdentifier.createTo(radioId);
        }
        return this.mTargetRadioId;
    }

    public PacketControl getPacketControl() {
        if (this.mPacketControl == null) {
            this.mPacketControl = new PacketControl(this.getMessage().getInt(PACKET_CONTROL, this.getOffset()));
        }
        return this.mPacketControl;
    }

    public int getCommandNumerator() {
        return this.getMessage().getInt(COMMAND_NUMERATOR, this.getOffset());
    }

    public ModularDataType getModularDataType() {
        return ModularDataType.fromValue(this.getMessage().getInt(SUB_DATA_1_MESSAGE_TYPE, this.getOffset()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR RADIO:");
        sb.append(this.getRadioId());
        sb.append(" MODULAR REQUEST TYPE:").append((Object)this.getModularDataType());
        sb.append(" MESSAGE NUMBER:").append(this.getCommandNumerator());
        return sb.toString();
    }
}

