/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

public class FragmentControl {
    private static final int BIT_MASK_ORIGINATION = 128;
    private static final int BIT_MASK_LAST_FRAGMENT = 64;
    private static final int BIT_MASK_FRAGMENT_INDEX = 63;
    private int mValue;

    public FragmentControl(int value) {
        this.mValue = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOrigination().name());
        sb.append(" ORIGINATED FRAGMENT #").append(this.getFragmentIndex());
        if (this.isLastFragment()) {
            sb.append(" FINAL");
        }
        return sb.toString();
    }

    public Origination getOrigination() {
        return this.isSet(128) ? Origination.UNIT : Origination.APPLICATION;
    }

    public boolean isLastFragment() {
        return this.isSet(64);
    }

    public int getFragmentIndex() {
        return this.mValue & 0x3F;
    }

    private boolean isSet(int bitMask) {
        return (this.mValue & bitMask) == bitMask;
    }

    public static enum Origination {
        UNIT,
        APPLICATION;

    }
}

