/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import java.util.Map;
import java.util.TreeMap;

public enum Command {
    IMMEDIATE_STATUS_REQUEST(0, "IMMEDIATE STATUS AND LOCATION"),
    UNIT_STATUS_CHANGE(2, "CHANGE UNIT STATUS"),
    OUTPUT_STATE_CHANGE(3, "CHANGE OUTPUT STATE"),
    DISABLE_ACTIVE_TRANSMISSIONS(4, "DISABLE ACTIVE TRANSMISSIONS"),
    TRACKING_CONTROL(5, "TRACKING CONTROL"),
    ALARM_CADENCE_CONTROL(6, "ALARM CADENCE CONTROL"),
    COMMENCE_GRADUAL_ENGINE_STOP(7, "COMMENCE GRADUAL ENGINE STOP"),
    INITIATE_CSD_SESSION(12, "INITIATE CSD SESSION"),
    ERASE_TRACKING_LOG(13, "ERASE TRACKING LOG"),
    RESET_GPS_RECEIVER(14, "RESET GPS RECEIVER"),
    SEQUENCE_DETECTION_LEARN(15, "SEQUENCE DETECTION LEARN"),
    FORCE_GPS_ENERGIZING(16, "FORCE GPS ACTIVATION"),
    CONNECT_TO_SERVER(18, "CONNECT TO SERVER"),
    MANUFACTURER_RESERVED(19, "MANUFACTURER RESERVED"),
    CALIBRATE_FREQUENCY_COUNTERS(20, "CALIBRATE FREQUENCY COUNTERS"),
    CONTROL_COM_PORT_TRANSPARENT_MODE(21, "CONTROL COM PORT TRANSPARENT MODE"),
    QUERY_CONNECTED_TRAILER_ID(22, "QUERY CONNECTED TRAILER ID"),
    CAMERA_SUPPORT(24, "CAMERA SUPPORT"),
    NANO_WAKEUP_AND_STATUS_REQUEST(25, "NANO WAKEUP AND STATUS REQUEST"),
    ENABLE_MODEM_FOTA_SESSION(26, "ENABLE MODEM FOTA SESSION"),
    PHSN_CONTROL(27, "PHSN CONTROL"),
    CALL_CONTROL(28, "CALL SHARING 2 CONTROL"),
    CELLO_TRACK_T(29, "CELLO TRACK T"),
    CALIBRATE_CAN_GPS_SPEED(31, "CALIBRATE CAN GPS SPEED"),
    UNKNOWN(-1, "UNKNOWN COMMAND");

    private int mValue;
    private String mLabel;
    private static Map<Integer, Command> LOOKUP_MAP;

    private Command(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public static Command fromValue(int value) {
        if (LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, Command>();
        for (Command command : Command.values()) {
            LOOKUP_MAP.put(command.getValue(), command);
        }
    }
}

