/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.IPProtocol;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.UnknownCompressedHeaderPacket;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPMessageFactory;
import io.github.dsheirer.module.decode.ip.icmp.ICMPPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Header;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPPort;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPPacketHeader;
import io.github.dsheirer.module.decode.p25.reference.IPHeaderCompression;

public class PacketMessageFactory {
    public static IPacket create(SNDCPPacketHeader sndcpPacketHeader, CorrectedBinaryMessage message, int offset) {
        if (sndcpPacketHeader.getIPHeaderCompression() == IPHeaderCompression.NONE) {
            int version = IPV4Header.getIPVersion(message, offset);
            switch (version) {
                case 4: {
                    return new IPV4Packet(message, offset);
                }
            }
            return new UnknownPacket(message, offset);
        }
        return new UnknownCompressedHeaderPacket(sndcpPacketHeader, message, offset);
    }

    public static IPacket create(CorrectedBinaryMessage message, int offset) {
        int version = IPV4Header.getIPVersion(message, offset);
        switch (version) {
            case 4: {
                return new IPV4Packet(message, offset);
            }
        }
        return new UnknownPacket(message, offset);
    }

    public static IPacket create(IPProtocol protocol, CorrectedBinaryMessage binaryMessage, int offset) {
        switch (protocol) {
            case ICMP: {
                return new ICMPPacket(binaryMessage, offset);
            }
            case UDP: {
                return new UDPPacket(binaryMessage, offset);
            }
        }
        return new UnknownPacket(binaryMessage, offset);
    }

    public static IPacket createUDPPayload(UDPPort sourcePort, UDPPort destinationPort, CorrectedBinaryMessage binaryMessage, int offset) {
        switch ((Integer)destinationPort.getValue()) {
            case 231: {
                if (!MCGPHeader.isCellocatorMessage(binaryMessage, offset)) break;
                return MCGPMessageFactory.create(binaryMessage, offset);
            }
            case 4001: {
                return new LRRPPacket(binaryMessage, offset);
            }
            case 4004: {
                return new XCMPPacket(binaryMessage, offset);
            }
            case 4005: {
                return new ARSPacket(binaryMessage, offset);
            }
            case 4007: {
                break;
            }
            case 4008: {
                break;
            }
            case 4009: {
                break;
            }
            case 4012: {
                break;
            }
        }
        switch ((Integer)sourcePort.getValue()) {
            case 231: {
                if (!MCGPHeader.isCellocatorMessage(binaryMessage, offset)) break;
                return MCGPMessageFactory.create(binaryMessage, offset);
            }
        }
        if (MCGPHeader.isCellocatorMessage(binaryMessage, offset)) {
            return MCGPMessageFactory.create(binaryMessage, offset);
        }
        return new UnknownPacket(binaryMessage, offset);
    }
}

