/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2.identifier;

import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.protocol.Protocol;

public class FleetsyncIdentifier
extends TalkgroupIdentifier
implements Comparable<FleetsyncIdentifier> {
    public FleetsyncIdentifier(Integer talkgroup, Role role) {
        super(talkgroup, role);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.FLEETSYNC;
    }

    public String formatted() {
        return String.format("%03d:%04d", this.getFleet(), this.getIdent());
    }

    public int getFleet() {
        return (Integer)this.getValue() >> 12 & 0xFF;
    }

    public int getIdent() {
        return (Integer)this.getValue() & 0xFFF;
    }

    public static FleetsyncIdentifier createFromUser(int talkgroup) {
        return new FleetsyncIdentifier(talkgroup, Role.FROM);
    }

    public static FleetsyncIdentifier createToUser(int talkgroup) {
        return new FleetsyncIdentifier(talkgroup, Role.TO);
    }

    @Override
    public int compareTo(FleetsyncIdentifier o) {
        return ((Integer)this.getValue()).compareTo((Integer)o.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FleetsyncIdentifier)) {
            return false;
        }
        return this.compareTo((FleetsyncIdentifier)o) == 0;
    }
}

