/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.fleetsync2.FleetsyncMessageType;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import java.util.function.Function;

public class FleetsyncMessageFilter
extends Filter<IMessage, FleetsyncMessageType> {
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public FleetsyncMessageFilter() {
        super("Fleetsync Messages");
        for (FleetsyncMessageType type : FleetsyncMessageType.values()) {
            this.add(new FilterElement<FleetsyncMessageType>(type));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof Fleetsync2Message && super.canProcess(message);
    }

    @Override
    public Function<IMessage, FleetsyncMessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, FleetsyncMessageType> {
        private KeyExtractor(FleetsyncMessageFilter fleetsyncMessageFilter) {
        }

        @Override
        public FleetsyncMessageType apply(IMessage message) {
            if (message instanceof Fleetsync2Message) {
                Fleetsync2Message f2m = (Fleetsync2Message)message;
                return f2m.getMessageType();
            }
            return null;
        }
    }
}

