/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.fleetsync2.FleetsyncMessageType;
import io.github.dsheirer.module.decode.fleetsync2.message.AutomaticNumberIdentification;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import io.github.dsheirer.module.decode.fleetsync2.message.LocationReport;
import io.github.dsheirer.module.decode.fleetsync2.message.Status;
import io.github.dsheirer.sample.Listener;

public class Fleetsync2MessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private Listener<IMessage> mMessageListener;

    public void dispose() {
        this.mMessageListener = null;
    }

    @Override
    public void receive(CorrectedBinaryMessage message) {
        FleetsyncMessageType messageType = Fleetsync2Message.getMessageType(message);
        switch (messageType) {
            case GPS: {
                this.broadcast(new LocationReport(message, System.currentTimeMillis()));
                break;
            }
            case STATUS: {
                this.broadcast(new Status(message, System.currentTimeMillis()));
                break;
            }
            default: {
                this.broadcast(new AutomaticNumberIdentification(message, System.currentTimeMillis()));
            }
        }
    }

    private void broadcast(IMessage message) {
        if (this.mMessageListener != null) {
            this.mMessageListener.receive(message);
        }
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

