/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event.filter;

import com.jidesoft.swing.JideButton;
import io.github.dsheirer.filter.FilterEditorPanel;
import io.github.dsheirer.filter.FilterSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EventFilterButton<T>
extends JideButton {
    private static final long serialVersionUID = 1L;

    public EventFilterButton(String dialogTitle, FilterSet<T> filterSet) {
        this("Filter", dialogTitle, filterSet);
    }

    public EventFilterButton(String buttonLabel, String dialogTitle, FilterSet<T> filterSet) {
        super(buttonLabel);
        this.addActionListener(new EventFilterActionHandler(dialogTitle, filterSet));
    }

    public class EventFilterActionHandler
    implements ActionListener {
        private String mTitle;
        private FilterSet<T> mFilterSet;

        public EventFilterActionHandler(String title, FilterSet<T> filterSet) {
            this.mTitle = title;
            this.mFilterSet = filterSet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame editor = new JFrame();
            editor.setTitle(this.mTitle);
            editor.setLocationRelativeTo((Component)((Object)EventFilterButton.this));
            editor.setSize(600, 400);
            editor.setDefaultCloseOperation(2);
            editor.setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill][][]"));
            FilterEditorPanel panel = new FilterEditorPanel(this.mFilterSet);
            JScrollPane scroller = new JScrollPane(panel);
            scroller.setViewportView(panel);
            editor.add((Component)scroller, "wrap");
            JButton close = new JButton("Close");
            close.addActionListener(e1 -> editor.dispose());
            editor.add(close);
            EventQueue.invokeLater(() -> editor.setVisible(true));
        }
    }
}

