/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice.embedded;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.ShortBurstOpcode;

public abstract class ShortBurst {
    private static final int[] CRC3 = new int[]{0, 1, 2};
    private static final int[] OPCODE = new int[]{8, 9, 10};
    private static final int[] FULL_MESSAGE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private CorrectedBinaryMessage mMessage;
    private boolean mValid = true;

    public ShortBurst(CorrectedBinaryMessage message) {
        this.mMessage = message;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public boolean isValid() {
        return this.mValid;
    }

    protected void setValid(boolean valid) {
        this.mValid = valid;
    }

    public int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    public ShortBurstOpcode getOpcode() {
        return ShortBurst.getOpcode(this.getMessage());
    }

    public static ShortBurstOpcode getOpcode(BinaryMessage message) {
        return ShortBurstOpcode.fromValue(message.getInt(OPCODE));
    }

    public boolean passesCRC3() {
        int checksum = this.getMessage().getInt(FULL_MESSAGE);
        int polynomial = 1408;
        int checkBit = 1024;
        for (int x = 10; x >= 0; --x) {
            if (checksum == 0) {
                return true;
            }
            if ((checksum & checkBit) == checkBit) {
                checksum ^= polynomial;
            }
            polynomial >>= 1;
            checkBit >>= 1;
        }
        return checksum == 0;
    }
}

