/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice.embedded;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.type.EncryptionAlgorithm;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.ShortBurst;

public class EncryptionParameters
extends ShortBurst {
    private static final int[] KEY = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] ALGORITHM = new int[]{8, 9, 10};

    public EncryptionParameters(CorrectedBinaryMessage message) {
        super(message);
    }

    public int getKey() {
        return this.getMessage().getInt(KEY);
    }

    public int getAlgorithmValue() {
        return this.getMessage().getInt(ALGORITHM);
    }

    public EncryptionAlgorithm getAlgorithm() {
        int algorithm = this.getAlgorithmValue();
        return switch (algorithm) {
            case 1 -> EncryptionAlgorithm.DMRA_RC4;
            case 4 -> EncryptionAlgorithm.DMRA_AES128;
            case 5 -> EncryptionAlgorithm.DMRA_AES256;
            default -> EncryptionAlgorithm.UNKNOWN;
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ENCRYPTION ALGORITHM:");
        if (this.getAlgorithm() == EncryptionAlgorithm.UNKNOWN) {
            sb.append(this.getAlgorithmValue());
        } else {
            sb.append((Object)this.getAlgorithm());
        }
        sb.append(" KEY:").append(this.getKey());
        return sb.toString();
    }
}

