/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public enum TalkerAliasDataFormat {
    BIT_7(0, 7, "ASCII-7"),
    BIT_8(1, 8, "ASCII-8"),
    UTF_8(2, 8, "UTF-8"),
    UNICODE_UTF_16_BE(3, 16, "UNICODE-16");

    private int mValue;
    private int mBitsPerCharacter;
    private String mLabel;

    private TalkerAliasDataFormat(int value, int bitsPerCharacter, String label) {
        this.mValue = value;
        this.mBitsPerCharacter = bitsPerCharacter;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getBitsPerCharacter() {
        return this.mBitsPerCharacter;
    }

    public static TalkerAliasDataFormat fromValue(int value) {
        if (value < 0 || value > 3) {
            throw new IllegalArgumentException("Invalid value - out of range (0-3): " + value);
        }
        return TalkerAliasDataFormat.values()[value];
    }

    public String toString() {
        return this.mLabel;
    }
}

