/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.identifier.DMRNetwork;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.type.AbstractStructure;
import io.github.dsheirer.module.decode.dmr.message.type.Model;
import io.github.dsheirer.module.decode.dmr.message.type.PAR;

public class SystemIdentityCode
extends AbstractStructure {
    private static final int[] MODEL = new int[]{0, 1};
    private static final int[] TINY_NET = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static final int[] TINY_SITE = new int[]{11, 12, 13};
    private static final int[] SMALL_NET = new int[]{2, 3, 4, 5, 6, 7, 8};
    private static final int[] SMALL_SITE = new int[]{9, 10, 11, 12, 13};
    private static final int[] LARGE_NET = new int[]{2, 3, 4, 5};
    private static final int[] LARGE_SITE = new int[]{6, 7, 8, 9, 10, 11, 12, 13};
    private static final int[] HUGE_NET = new int[]{2, 3};
    private static final int[] HUGE_SITE = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    private static final int[] PAR_SUBFIELD = new int[]{14, 15};
    private DMRNetwork mNetwork;
    private DMRSite mSite;
    private boolean mHasPAR;

    public SystemIdentityCode(CorrectedBinaryMessage message, int offset, boolean hasPAR) {
        super(message, offset);
        this.mHasPAR = hasPAR;
    }

    public boolean hasPAR() {
        return this.mHasPAR;
    }

    public PAR getPAR() {
        if (this.hasPAR()) {
            return PAR.fromValue(this.getMessage().getInt(PAR_SUBFIELD, this.getOffset()));
        }
        return PAR.UNKNOWN;
    }

    public Model getModel() {
        return Model.fromValue(this.getMessage().getInt(MODEL, this.getOffset()));
    }

    public DMRNetwork getNetwork() {
        if (this.mNetwork == null) {
            switch (this.getModel()) {
                case TINY: {
                    this.mNetwork = new DMRNetwork(this.getMessage().getInt(TINY_NET, this.getOffset()));
                    break;
                }
                case SMALL: {
                    this.mNetwork = new DMRNetwork(this.getMessage().getInt(SMALL_NET, this.getOffset()));
                    break;
                }
                case LARGE: {
                    this.mNetwork = new DMRNetwork(this.getMessage().getInt(LARGE_NET, this.getOffset()));
                    break;
                }
                case HUGE: {
                    this.mNetwork = new DMRNetwork(this.getMessage().getInt(HUGE_NET, this.getOffset()));
                }
            }
        }
        return this.mNetwork;
    }

    public DMRSite getSite() {
        if (this.mSite == null) {
            switch (this.getModel()) {
                case TINY: {
                    this.mSite = new DMRSite(this.getMessage().getInt(TINY_SITE, this.getOffset()));
                    break;
                }
                case SMALL: {
                    this.mSite = new DMRSite(this.getMessage().getInt(SMALL_SITE, this.getOffset()));
                    break;
                }
                case LARGE: {
                    this.mSite = new DMRSite(this.getMessage().getInt(LARGE_SITE, this.getOffset()));
                    break;
                }
                case HUGE: {
                    this.mSite = new DMRSite(this.getMessage().getInt(HUGE_SITE, this.getOffset()));
                }
            }
        }
        return this.mSite;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getModel());
        sb.append(" NETWORK:").append(this.getNetwork().getValue());
        sb.append(" SITE:").append(this.getSite().getValue());
        return sb.toString();
    }
}

