/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import com.google.common.base.Joiner;
import java.util.ArrayList;

public class ServiceOptions {
    private static final int EMERGENCY_MASK = 128;
    private static final int ENCRYPTION_MASK = 64;
    private static final int RESERVED_1 = 32;
    private static final int RESERVED_2 = 16;
    private static final int BROADCAST_SERVICE_MASK = 8;
    private static final int OPEN_VOICE_CALL_MODE_MASK = 4;
    private static final int PRIORITY_MASK = 3;
    private int mValue;

    public ServiceOptions(int value) {
        this.mValue = value;
    }

    public boolean isEmergency() {
        return this.isSet(128);
    }

    public boolean isEncrypted() {
        return this.isSet(64);
    }

    public boolean isBroadcastService() {
        return this.isSet(8);
    }

    public boolean isOpenVoiceCallMode() {
        return this.isSet(4);
    }

    public boolean isReserved1() {
        return this.isSet(32);
    }

    public boolean isReserved2() {
        return this.isSet(16);
    }

    public int getPriority() {
        return this.mValue & 3;
    }

    private boolean isSet(int mask) {
        return (this.mValue & mask) == mask;
    }

    public String toString() {
        ArrayList<Object> flags = new ArrayList<Object>();
        if (this.isEmergency()) {
            flags.add("EMERGENCY");
        }
        if (this.isEncrypted()) {
            flags.add("ENCRYPTED");
        }
        if (this.isBroadcastService()) {
            flags.add("BROADCAST");
        }
        if (this.isOpenVoiceCallMode()) {
            flags.add("OVCM");
        }
        if (this.isReserved1()) {
            flags.add("RSVD1");
        }
        if (this.isReserved2()) {
            flags.add("RSVD2");
        }
        if (this.getPriority() > 0) {
            flags.add("PRIORITY-" + this.getPriority());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SERVICE OPTIONS [");
        if (!flags.isEmpty()) {
            sb.append(Joiner.on((String)",").join(flags));
        }
        sb.append("]");
        return sb.toString();
    }
}

