/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import java.util.function.Function;

public class VoiceMessageFilter
extends Filter<IMessage, DMRSyncPattern> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public VoiceMessageFilter() {
        super("Voice Messages");
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BASE_STATION_VOICE));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BS_VOICE_FRAME_B));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BS_VOICE_FRAME_C));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BS_VOICE_FRAME_D));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BS_VOICE_FRAME_E));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.BS_VOICE_FRAME_F));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MOBILE_STATION_VOICE));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MS_VOICE_FRAME_B));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MS_VOICE_FRAME_C));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MS_VOICE_FRAME_D));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MS_VOICE_FRAME_E));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.MS_VOICE_FRAME_F));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.DIRECT_MODE_VOICE_TIMESLOT_1));
        this.add(new FilterElement<DMRSyncPattern>(DMRSyncPattern.DIRECT_MODE_VOICE_TIMESLOT_2));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof VoiceMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, DMRSyncPattern> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, DMRSyncPattern> {
        private KeyExtractor(VoiceMessageFilter voiceMessageFilter) {
        }

        @Override
        public DMRSyncPattern apply(IMessage message) {
            if (message instanceof VoiceMessage) {
                VoiceMessage voice = (VoiceMessage)message;
                return voice.getSyncPattern();
            }
            return null;
        }
    }
}

