/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.filter.LinkControlMessageFilter;
import java.util.ArrayList;

public class LinkControlMessageFilterSet
extends FilterSet<IMessage> {
    public LinkControlMessageFilterSet() {
        super("Short/Voice-Fragment Link Control Messages");
        ArrayList<LCOpcode> fullLinkControl = new ArrayList<LCOpcode>();
        ArrayList<LCOpcode> shortLinkControl = new ArrayList<LCOpcode>();
        for (LCOpcode opcode : LCOpcode.values()) {
            if (opcode.isFull()) {
                fullLinkControl.add(opcode);
                continue;
            }
            shortLinkControl.add(opcode);
        }
        this.addFilter(new LinkControlMessageFilter("Full Link Control", fullLinkControl));
        this.addFilter(new LinkControlMessageFilter("Short Link Control", shortLinkControl));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof LCMessage && super.canProcess(message);
    }
}

