/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import java.util.Collection;
import java.util.function.Function;

public class LinkControlMessageFilter
extends Filter<IMessage, LCOpcode> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public LinkControlMessageFilter(String name, Collection<LCOpcode> opcodes) {
        super(name);
        for (LCOpcode opcode : opcodes) {
            this.add(new FilterElement<LCOpcode>(opcode));
        }
    }

    @Override
    public Function<IMessage, LCOpcode> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, LCOpcode> {
        private KeyExtractor(LinkControlMessageFilter linkControlMessageFilter) {
        }

        @Override
        public LCOpcode apply(IMessage message) {
            if (message instanceof LCMessage) {
                LCMessage lcMessage = (LCMessage)message;
                return lcMessage.getOpcode();
            }
            return null;
        }
    }
}

