/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.filter.ControlMessageFilter;
import java.util.ArrayList;

public class ControlMessageFilterSet
extends FilterSet<IMessage> {
    public ControlMessageFilterSet() {
        super("Control (CSBK) Messages");
        this.addFilter(new ControlMessageFilter("Data Channel Grants", Opcode.DATA_CHANNEL_GRANTS));
        this.addFilter(new ControlMessageFilter("Data-Related", Opcode.DATA_OPCODES));
        this.addFilter(new ControlMessageFilter("Mobile Request/Response", Opcode.MOBILE_REQUEST_RESPONSE));
        this.addFilter(new ControlMessageFilter("Network Request/Response", Opcode.NETWORK_REQUEST_RESPONSE));
        this.addFilter(new ControlMessageFilter("Voice Channel Grants", Opcode.VOICE_CHANNEL_GRANTS));
        this.addFilter(new ControlMessageFilter("Hytera", Opcode.HYTERA));
        this.addFilter(new ControlMessageFilter("Motorola Capacity Max", Opcode.MOTOROLA_CAPACITY_MAX));
        this.addFilter(new ControlMessageFilter("Motorola Capacity Plus", Opcode.MOTOROLA_CAPACITY_PLUS));
        this.addFilter(new ControlMessageFilter("Motorola Connect Plus", Opcode.MOTOROLA_CONNECT_PLUS));
        ArrayList<Opcode> otherOpcodes = new ArrayList<Opcode>();
        for (Opcode opcode : Opcode.values()) {
            if (opcode.isGrouped()) continue;
            otherOpcodes.add(opcode);
        }
        this.addFilter(new ControlMessageFilter("Other/Unknown", otherOpcodes));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof CSBKMessage && super.canProcess(message);
    }
}

