/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.packet;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTShortMessageService
extends DMRMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTShortMessageService.class);
    private UDTHeader mHeader;
    private String mSMS;

    public UDTShortMessageService(UDTHeader header, CorrectedBinaryMessage payload) {
        super(payload, header.getTimestamp(), header.getTimeslot());
        this.mHeader = header;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.mHeader.getIdentifiers();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.mHeader.getSlotType().getColorCode());
        sb.append(" SMS MESSAGE:").append(this.getSMS());
        sb.append(" FROM:").append(this.mHeader.getSourceLLID());
        sb.append(" TO:").append(this.mHeader.getDestinationLLID());
        sb.append(" HEX:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public String getSMS() {
        if (this.mSMS == null) {
            switch (this.mHeader.getFormat()) {
                case UNICODE_16: {
                    this.mSMS = this.parseUnicodePayload();
                    break;
                }
                case ASCII_7: {
                    this.mSMS = this.parseISO7Payload();
                    break;
                }
                case ASCII_8: {
                    this.mSMS = this.parseISO8Payload();
                    break;
                }
                case BCD_4_BITS: {
                    this.mSMS = this.parseBCD4Payload();
                    break;
                }
                case BINARY: 
                case MOBILE_SUBSCRIBER_OR_TALKGROUP_ADDRESS: 
                case NMEA_GPS_LOCATION_CODED: 
                case IP_ADDRESS: 
                case VENDOR_PROPRIETARY_8: 
                case VENDOR_PROPRIETARY_9: 
                case MIXED_FORMAT: 
                case UNKNOWN: {
                    LOGGER.warn("Unrecognized UDT Short Data Format: " + String.valueOf((Object)this.mHeader.getFormat()) + " - Please send this to the sdrtrunk developer - Hex:" + this.getMessage().toHexString() + " As String:" + new String(this.getMessage().getBytes()));
                    this.mSMS = "Error:" + new String(this.getMessage().getBytes());
                }
            }
        }
        if (this.mSMS == null) {
            this.mSMS = "error - unrecognized format: " + String.valueOf((Object)this.mHeader.getFormat());
        }
        return this.mSMS;
    }

    private String parseUnicodePayload() {
        int length = this.getMessage().size();
        length -= this.mHeader.getPadNibbleCount() * 4;
        length -= 16;
        if ((length -= 16) > 16) {
            return this.getMessage().parseUnicode(0, length / 16);
        }
        return "(insufficient data)";
    }

    private String parseISO7Payload() {
        int length = this.getMessage().size();
        if ((length -= this.mHeader.getPadNibbleCount() * 4) > 7) {
            return this.getMessage().parseISO7(0, length / 7);
        }
        return "(insufficient data)";
    }

    private String parseISO8Payload() {
        int length = this.getMessage().size();
        if ((length -= this.mHeader.getPadNibbleCount() * 4) > 8) {
            return this.getMessage().parseISO8(0, length / 8);
        }
        return "(insufficient data)";
    }

    private String parseBCD4Payload() {
        int length = this.getMessage().size();
        if ((length -= this.mHeader.getPadNibbleCount() * 4) > 4) {
            return this.getMessage().parseBCD4(0, length / 4);
        }
        return "(insufficient data)";
    }
}

