/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.packet;

import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Preamble;
import io.github.dsheirer.module.decode.dmr.message.data.header.PacketSequenceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequence;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequenceMessageFactory;
import io.github.dsheirer.sample.Listener;

public class PacketSequenceAssembler {
    private Listener<IMessage> mMessageListener;
    private PacketSequence mTimeslot1Sequence;
    private PacketSequence mTimeslot2Sequence;

    private PacketSequence getPacketSequence(int timeslot) {
        if (timeslot == 1) {
            if (this.mTimeslot1Sequence == null) {
                this.mTimeslot1Sequence = new PacketSequence(1);
            }
            return this.mTimeslot1Sequence;
        }
        if (this.mTimeslot2Sequence == null) {
            this.mTimeslot2Sequence = new PacketSequence(2);
        }
        return this.mTimeslot2Sequence;
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void dispatchPacketSequence(int timeslot) {
        IMessage message;
        PacketSequence packetSequence;
        PacketSequence packetSequence2 = packetSequence = timeslot == 1 ? this.mTimeslot1Sequence : this.mTimeslot2Sequence;
        if (packetSequence != null && this.mMessageListener != null && (message = PacketSequenceMessageFactory.create(packetSequence)) != null) {
            this.mMessageListener.receive(message);
        }
        if (timeslot == 1) {
            this.mTimeslot1Sequence = null;
        } else {
            this.mTimeslot2Sequence = null;
        }
    }

    public void process(Preamble preamble) {
        int timeslot = preamble.getTimeslot();
        PacketSequence packetSequence = this.getPacketSequence(timeslot);
        if (packetSequence.hasPacketSequenceHeader() || packetSequence.hasProprietaryDataHeader() || packetSequence.hasDataBlocks()) {
            this.dispatchPacketSequence(timeslot);
            packetSequence = this.getPacketSequence(timeslot);
        }
        packetSequence.addPreamble(preamble);
    }

    public void process(PacketSequenceHeader header) {
        int timeslot = header.getTimeslot();
        PacketSequence packetSequence = this.getPacketSequence(timeslot);
        if (packetSequence.hasPacketSequenceHeader() || packetSequence.hasProprietaryDataHeader() || packetSequence.hasDataBlocks()) {
            this.dispatchPacketSequence(timeslot);
            packetSequence = this.getPacketSequence(timeslot);
        }
        packetSequence.setPacketSequenceHeader(header);
    }

    public void process(UDTHeader header) {
        int timeslot = header.getTimeslot();
        PacketSequence packetSequence = this.getPacketSequence(timeslot);
        if (packetSequence.hasPacketSequenceHeader() || packetSequence.hasProprietaryDataHeader() || packetSequence.hasDataBlocks()) {
            this.dispatchPacketSequence(timeslot);
            packetSequence = this.getPacketSequence(timeslot);
        }
        packetSequence.setUDTHeader(header);
    }

    public void process(ProprietaryDataHeader proprietaryHeader) {
        int timeslot = proprietaryHeader.getTimeslot();
        PacketSequence packetSequence = this.getPacketSequence(timeslot);
        if (packetSequence.hasProprietaryDataHeader() || packetSequence.hasDataBlocks()) {
            this.dispatchPacketSequence(timeslot);
            packetSequence = this.getPacketSequence(timeslot);
        }
        packetSequence.setProprietaryHeader(proprietaryHeader);
    }

    public void process(DataBlock dataBlock) {
        int timeslot = dataBlock.getTimeslot();
        PacketSequence packetSequence = this.getPacketSequence(timeslot);
        packetSequence.addDataBlock(dataBlock);
        if (packetSequence.isComplete()) {
            this.dispatchPacketSequence(timeslot);
        }
    }
}

