/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.packet;

import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Preamble;
import io.github.dsheirer.module.decode.dmr.message.data.header.PacketSequenceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.hytera.HyteraDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.motorola.MotorolaDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.type.EncryptionAlgorithm;
import java.util.ArrayList;
import java.util.List;

public class PacketSequence {
    private final int mTimeslot;
    private PacketSequenceHeader mPacketSequenceHeader;
    private UDTHeader mUDTHeader;
    private ProprietaryDataHeader mProprietaryDataHeader;
    private final List<Preamble> mPreambles = new ArrayList<Preamble>();
    private final List<DataBlock> mDataBlocks = new ArrayList<DataBlock>();

    public PacketSequence(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PACKET SEQUENCE ");
        sb.append(" TS:").append(this.getTimeslot());
        if (this.mPacketSequenceHeader != null) {
            sb.append(this.mPacketSequenceHeader);
        } else if (this.mUDTHeader != null) {
            sb.append(this.mUDTHeader);
        }
        sb.append(" HEADER:").append(this.hasPacketSequenceHeader());
        sb.append(" PROPRIETARY HEADER:").append(this.hasProprietaryDataHeader());
        sb.append(" DATA BLOCKS:").append(this.mDataBlocks.size());
        sb.append(" PREAMBLES:").append(this.mPreambles.size());
        return sb.toString();
    }

    public boolean isComplete() {
        int count = 0;
        if (this.hasProprietaryDataHeader()) {
            ++count;
        }
        count += this.mDataBlocks.size();
        if (this.hasPacketSequenceHeader()) {
            return this.getPacketSequenceHeader().getBlocksToFollow() == count;
        }
        return false;
    }

    public boolean isEncrypted() {
        if (this.hasProprietaryDataHeader()) {
            if (this.getProprietaryDataHeader() instanceof MotorolaDataEncryptionHeader) {
                return true;
            }
            ProprietaryDataHeader proprietaryDataHeader = this.getProprietaryDataHeader();
            if (proprietaryDataHeader instanceof HyteraDataEncryptionHeader) {
                HyteraDataEncryptionHeader hdeh = (HyteraDataEncryptionHeader)proprietaryDataHeader;
                return hdeh.getAlgorithm() != EncryptionAlgorithm.NO_ENCRYPTION;
            }
        }
        return false;
    }

    public int getTimeslot() {
        return this.mTimeslot;
    }

    public void setPacketSequenceHeader(PacketSequenceHeader header) {
        this.mPacketSequenceHeader = header;
    }

    public void setUDTHeader(UDTHeader header) {
        this.mUDTHeader = header;
    }

    public void setProprietaryHeader(ProprietaryDataHeader header) {
        this.mProprietaryDataHeader = header;
    }

    public void addPreamble(Preamble preamble) {
        this.mPreambles.add(preamble);
    }

    public void addDataBlock(DataBlock dataBlock) {
        this.mDataBlocks.add(dataBlock);
    }

    public PacketSequenceHeader getPacketSequenceHeader() {
        return this.mPacketSequenceHeader;
    }

    public boolean hasPacketSequenceHeader() {
        return this.mPacketSequenceHeader != null;
    }

    public UDTHeader getUDTHeader() {
        return this.mUDTHeader;
    }

    public boolean hasUDTHeader() {
        return this.getUDTHeader() != null;
    }

    public ProprietaryDataHeader getProprietaryDataHeader() {
        return this.mProprietaryDataHeader;
    }

    public boolean hasProprietaryDataHeader() {
        return this.mProprietaryDataHeader != null;
    }

    public List<DataBlock> getDataBlocks() {
        return this.mDataBlocks;
    }

    public boolean hasDataBlocks() {
        return !this.mDataBlocks.isEmpty();
    }
}

