/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.mbc;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.data.header.MBCHeader;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MultiCSBK;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import java.util.Collections;
import java.util.List;

public class UnknownMultiCSBK
extends MultiCSBK {
    public UnknownMultiCSBK(MBCHeader header, List<MBCContinuationBlock> continuationBlocks) {
        super(header, continuationBlocks);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK *UNKNOWN*");
        Vendor vendor = this.getVendor();
        if (vendor == Vendor.UNKNOWN) {
            sb.append(" VENDOR:").append(this.getVendorID());
        } else if (vendor != Vendor.STANDARD) {
            sb.append(" ").append((Object)vendor);
        }
        Opcode opcode = this.getOpcode();
        if (opcode != Opcode.UNKNOWN) {
            sb.append(" ").append((Object)opcode);
        } else {
            sb.append(" UNKNOWN OPCODE:").append(this.getOpcodeValue());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        for (MBCContinuationBlock block : this.mBlocks) {
            sb.append(block.getMessage().toHexString());
        }
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

