/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRNetwork;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusTrafficChannel
extends ShortLCMessage {
    private static final int[] NETWORK = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SITE = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private DMRNetwork mNetwork;
    private DMRSite mSite;
    private List<Identifier> mIdentifiers;

    public ConnectPlusTrafficChannel(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR] ");
        }
        sb.append("SLC MOTOROLA CON+ TRAFFIC CHANNEL NETWORK:").append(this.getNetwork());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public DMRNetwork getNetwork() {
        if (this.mNetwork == null) {
            this.mNetwork = DMRNetwork.create(this.getMessage().getInt(NETWORK));
        }
        return this.mNetwork;
    }

    public DMRSite getSite() {
        if (this.mSite == null) {
            this.mSite = DMRSite.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getNetwork());
            this.mIdentifiers.add(this.getSite());
        }
        return this.mIdentifiers;
    }
}

