/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera.HyteraFullLC;
import java.util.ArrayList;
import java.util.List;

public class HyteraTerminator
extends HyteraFullLC {
    private TalkgroupIdentifier mTalkgroup;
    private List<Identifier> mIdentifiers;

    public HyteraTerminator(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("FLC HYTERA TERMINATOR USER FM:");
        sb.append(this.getSourceRadio());
        sb.append(" TO:").append(this.getTalkgroup());
        if (this.isAllChannelsBusy()) {
            sb.append(" ALL REPEATERS BUSY");
        } else {
            sb.append(" FREE REPEATER:").append(this.getFreeRepeater());
        }
        if (this.hasPriorityCall()) {
            sb.append(" PRIORITY CALL FOR:").append(this.getPriorityCallHashedAddress());
            sb.append(" ON REPEATER:").append(this.getPriorityCallRepeater());
        }
        sb.append(" ").append(this.getServiceOptions());
        return sb.toString();
    }

    public TalkgroupIdentifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTalkgroup;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

