/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.TalkerAliasDataFormat;
import java.util.Collections;
import java.util.List;

public class TalkerAliasHeader
extends FullLCMessage {
    private static final int[] FORMAT = new int[]{16, 17};
    private static final int[] LENGTH = new int[]{18, 19, 20, 21, 22};
    private static final int PAYLOAD_START = 23;
    private static final int PAYLOAD_END = 72;

    public TalkerAliasHeader(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    public TalkerAliasDataFormat getFormat() {
        return TalkerAliasDataFormat.fromValue(this.getMessage().getInt(FORMAT));
    }

    public int getCharacterLength() {
        return this.getMessage().getInt(LENGTH);
    }

    public int getTotalBitLength() {
        int total = this.getFormat().getBitsPerCharacter() * this.getCharacterLength();
        if (total > 217) {
            return 217;
        }
        return total;
    }

    public CorrectedBinaryMessage getPayloadFragment() {
        return this.getMessage().getSubMessage(23, 72);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FLC TALKER ALIAS HEADER");
        sb.append(" FORMAT:").append((Object)this.getFormat());
        sb.append(" CHARACTERS:").append(this.getCharacterLength());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }
}

