/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.alias.DmrTalkerAliasIdentifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.TalkerAliasDataFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkerAliasComplete
extends FullLCMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(TalkerAliasComplete.class);
    private TalkerAliasDataFormat mDataFormat;
    private int mCharacterCount;
    private String mAlias;
    private DmrTalkerAliasIdentifier mTalkerAliasIdentifier;

    public TalkerAliasComplete(CorrectedBinaryMessage message, TalkerAliasDataFormat format, int characterCount, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
        this.mDataFormat = format;
        this.mCharacterCount = characterCount;
    }

    @Override
    public LCOpcode getOpcode() {
        return LCOpcode.FULL_STANDARD_TALKER_ALIAS_COMPLETE;
    }

    @Override
    public int getOpcodeValue() {
        return this.getOpcode().getValue();
    }

    public String getAliasValue() {
        if (this.mAlias == null) {
            switch (this.mDataFormat) {
                case BIT_7: {
                    if (1 > this.mCharacterCount || this.mCharacterCount > 31) break;
                    this.mAlias = this.getMessage().parseISO7(0, this.mCharacterCount);
                    break;
                }
                case BIT_8: {
                    if (1 > this.mCharacterCount || this.mCharacterCount > 27) break;
                    this.mAlias = this.getMessage().parseISO8(1, this.mCharacterCount);
                    break;
                }
                case UTF_8: {
                    if (1 > this.mCharacterCount || this.mCharacterCount > 27) break;
                    try {
                        this.mAlias = this.getMessage().parseUTF8(1, this.mCharacterCount);
                    }
                    catch (Exception e) {
                        LOGGER.info("Error decoding talker alias as UTF-8: " + e.getLocalizedMessage());
                    }
                    break;
                }
                case UNICODE_UTF_16_BE: {
                    if (1 > this.mCharacterCount || this.mCharacterCount > 13) break;
                    this.mAlias = this.getMessage().parseUnicode(1, this.mCharacterCount);
                }
            }
            if (this.mAlias == null) {
                this.mAlias = "";
            }
        }
        return this.mAlias;
    }

    public DmrTalkerAliasIdentifier getTalkerAliasIdentifier() {
        if (this.mTalkerAliasIdentifier == null && this.getAliasValue() != null && !this.getAliasValue().isEmpty()) {
            this.mTalkerAliasIdentifier = DmrTalkerAliasIdentifier.create(this.getAliasValue());
        }
        return this.mTalkerAliasIdentifier;
    }

    public boolean hasTalkerAliasIdentifier() {
        return this.getTalkerAliasIdentifier() != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FLC TALKER ALIAS:");
        if (this.hasTalkerAliasIdentifier()) {
            sb.append(this.getTalkerAliasIdentifier());
        } else {
            sb.append("(empty/error)");
        }
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.hasTalkerAliasIdentifier()) {
            ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
            identifiers.add(this.getTalkerAliasIdentifier());
            return identifiers;
        }
        return Collections.emptyList();
    }
}

