/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.AbstractVoiceChannelUser;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelUser
extends AbstractVoiceChannelUser {
    private static final int[] GROUP_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SOURCE_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private RadioIdentifier mRadio;
    private TalkgroupIdentifier mTalkgroup;
    private List<Identifier> mIdentifiers;

    public GroupVoiceChannelUser(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("FLC GROUP VOICE CHANNEL USER FM:");
        sb.append(this.getRadio());
        sb.append(" TO:").append(this.getTalkgroup());
        sb.append(" ").append(this.getServiceOptions());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public RadioIdentifier getRadio() {
        if (this.mRadio == null) {
            this.mRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mRadio;
    }

    public TalkgroupIdentifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mTalkgroup;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
            this.mIdentifiers.add(this.getRadio());
        }
        return this.mIdentifiers;
    }
}

