/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public abstract class FullLCMessage
extends LCMessage {
    private static final int ENCRYPTION_FLAG = 0;
    private static final int RESERVED = 1;
    protected static final int[] OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};

    public FullLCMessage(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public LCOpcode getOpcode() {
        return FullLCMessage.getOpcode(this.getMessage());
    }

    public int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    public static LCOpcode getOpcode(CorrectedBinaryMessage message) {
        return LCOpcode.fromValue(true, message.getInt(OPCODE), FullLCMessage.getVendor(message));
    }

    @Override
    public Vendor getVendor() {
        return FullLCMessage.getVendor(this.getMessage());
    }

    public static Vendor getVendor(CorrectedBinaryMessage message) {
        return Vendor.fromValue(message.getInt(VENDOR));
    }

    public int getVendorValue() {
        return this.getMessage().getInt(VENDOR);
    }

    public boolean isEncrypted() {
        return this.getMessage().get(0);
    }

    public boolean isReservedBitSet() {
        return this.getMessage().get(1);
    }
}

