/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.OctetDataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import java.util.ArrayList;
import java.util.List;

public abstract class ShortDataHeader
extends OctetDataHeader {
    private static final int RADIO_TALKGROUP_FLAG = 0;
    private static final int[] SERVICE_ACCESS_POINT = new int[]{8, 9, 10, 11};
    private static final int[] APPENDED_BLOCKS = new int[]{2, 3, 12, 13, 14, 15};
    private static final int[] DESTINATION_IDENTIFIER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SOURCE_RADIO = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SOURCE_PORT = new int[]{64, 65, 66};
    private static final int[] DESTINATION_PORT = new int[]{67, 68, 69};
    private IntegerIdentifier mDestinationLLID;
    private RadioIdentifier mSourceLLID;
    private List<Identifier> mIdentifiers;

    public ShortDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public int getSourcePort() {
        return this.getMessage().getInt(SOURCE_PORT);
    }

    public int getDestinationPort() {
        return this.getMessage().getInt(DESTINATION_PORT);
    }

    public static int getAppendedBlocks(CorrectedBinaryMessage message) {
        return message.getInt(APPENDED_BLOCKS);
    }

    public int getAppendedBlocks() {
        return ShortDataHeader.getAppendedBlocks(this.getMessage());
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    @Override
    public ServiceAccessPoint getServiceAccessPoint() {
        return ShortDataHeader.getServiceAccessPoint(this.getMessage());
    }

    @Override
    public IntegerIdentifier getDestinationLLID() {
        if (this.mDestinationLLID == null) {
            this.mDestinationLLID = this.getMessage().get(0) ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION_IDENTIFIER)) : DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION_IDENTIFIER));
        }
        return this.mDestinationLLID;
    }

    @Override
    public RadioIdentifier getSourceLLID() {
        if (this.mSourceLLID == null) {
            this.mSourceLLID = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE_RADIO));
        }
        return this.mSourceLLID;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationLLID());
            this.mIdentifiers.add(this.getSourceLLID());
        }
        return this.mIdentifiers;
    }
}

