/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.ShortDataHeader;

public class RawShortDataHeader
extends ShortDataHeader {
    private static final int RESYNCHRONIZE_FLAG = 70;
    private static final int FULL_MESSAGE_FLAG = 71;
    private static final int[] BIT_PADDING = new int[]{72, 73, 74, 75, 76, 77, 78, 79};

    public RawShortDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" RAW SHORT DATA");
        sb.append(" ").append((Object)this.getServiceAccessPoint());
        sb.append(" SOURCE PORT:").append(this.getSourcePort());
        sb.append(" DESTINATION PORT:").append(this.getDestinationPort());
        if (this.isFullMessage()) {
            sb.append(" FULL MESSAGE");
        }
        if (this.isResynchronize()) {
            sb.append(" RESYNCHRONIZE");
        }
        sb.append(" BIT PADDING:").append(this.getBitPadding());
        sb.append(" APPENDED BLOCKS:").append(this.getAppendedBlocks());
        return sb.toString();
    }

    public boolean isFullMessage() {
        return this.getMessage().get(71);
    }

    public boolean isResynchronize() {
        return this.getMessage().get(70);
    }

    public int getBitPadding() {
        return this.getMessage().getInt(BIT_PADDING);
    }
}

