/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.DataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public class ProprietaryDataHeader
extends DataHeader {
    private static final int[] SERVICE_ACCESS_POINT = new int[]{0, 1, 2, 3};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] VENDOR_DATA = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] HEADER_CRC = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};

    public ProprietaryDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" PROPRIETARY DATA HEADER");
        sb.append(" VENDOR:").append((Object)this.getVendor());
        sb.append(" ").append((Object)this.getServiceAccessPoint());
        sb.append(" VENDOR DATA:").append(this.getVendorData());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public String getVendorData() {
        return this.getMessage().getHex(VENDOR_DATA, 16);
    }

    public CorrectedBinaryMessage getPacketPrefix() {
        return null;
    }

    public static Vendor getVendor(BinaryMessage message) {
        return Vendor.fromValue(message.getInt(VENDOR));
    }

    public Vendor getVendor() {
        return ProprietaryDataHeader.getVendor(this.getMessage());
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return ProprietaryDataHeader.getServiceAccessPoint(this.getMessage());
    }
}

