/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.type.AnnouncementType;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import java.util.Collections;
import java.util.List;

public class MBCHeader
extends CSBKMessage {
    private static final int[] ANNOUNCEMENT_TYPE = new int[]{16, 17, 18, 19, 20};

    public MBCHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    protected int getCRCMask() {
        return 43690;
    }

    @Override
    public String toString() {
        Opcode opcode;
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" MULTI-BLOCK CSBK HEADER");
        Vendor vendor = this.getVendor();
        if (vendor != Vendor.STANDARD) {
            if (vendor == Vendor.UNKNOWN) {
                sb.append(" VENDOR:UNKNOWN (").append(this.getVendorID()).append(")");
            } else {
                sb.append(" ").append((Object)vendor);
            }
        }
        if ((opcode = this.getOpcode()) == Opcode.UNKNOWN) {
            sb.append(" UNKNOWN CSBKO:").append(this.getOpcodeValue());
        } else if (opcode == Opcode.HYTERA_08_ANNOUNCEMENT) {
            sb.append(" ANNOUNCEMENT:").append((Object)AnnouncementType.fromValue(this.getMessage().getInt(ANNOUNCEMENT_TYPE)));
        } else {
            sb.append(" ").append((Object)opcode);
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

