/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.PacketSequenceHeader;
import io.github.dsheirer.module.decode.dmr.message.type.DefinedDataFormat;
import java.util.ArrayList;
import java.util.List;

public class DefinedShortDataHeader
extends PacketSequenceHeader {
    private static final int[] BLOCKS_TO_FOLLOW = new int[]{2, 3, 12, 13, 14, 15};
    private static final int[] DEFINED_DATA_FORMAT = new int[]{64, 65, 66, 67, 68, 69};
    private static final int RESYNCHRONIZE_FLAG = 70;
    private static final int FULL_MESSAGE_FLAG = 71;
    private static final int[] BIT_PADDING = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] HEADER_CRC = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    private List<Identifier> mIdentifiers;

    public DefinedShortDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(this.isResponseRequested() ? " CONFIRMED" : " UNCONFIRMED");
        sb.append(" DEFINED SHORT DATA HEADER");
        sb.append(" FM:").append(this.getSourceLLID());
        sb.append(" TO:").append(this.getDestinationLLID());
        sb.append(" FORMAT:").append((Object)this.getDefinedDataFormat());
        sb.append(" ").append((Object)this.getServiceAccessPoint());
        if (this.isFullMessage()) {
            sb.append(" FULL MESSAGE");
        }
        if (this.isResynchronize()) {
            sb.append(" RESYNCHRONIZE");
        }
        sb.append(" BIT PADDING:").append(this.getBitPadding());
        sb.append(" BLOCKS TO FOLLOW:").append(this.getBlocksToFollow());
        return sb.toString();
    }

    public DefinedDataFormat getDefinedDataFormat() {
        return DefinedDataFormat.fromValue(this.getMessage().getInt(DEFINED_DATA_FORMAT));
    }

    public boolean isFullMessage() {
        return this.getMessage().get(71);
    }

    public boolean isResynchronize() {
        return this.getMessage().get(70);
    }

    public int getBitPadding() {
        return this.getMessage().getInt(BIT_PADDING);
    }

    @Override
    public int getBlocksToFollow() {
        return this.getMessage().getInt(BLOCKS_TO_FOLLOW);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationLLID());
            this.mIdentifiers.add(this.getSourceLLID());
        }
        return this.mIdentifiers;
    }
}

