/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRTier3Channel;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import io.github.dsheirer.module.decode.dmr.message.type.SystemIdentityCode;
import java.util.ArrayList;
import java.util.List;

public class VoteNowAdvice
extends Announcement
implements ITimeslotFrequencyReceiver {
    private static final int VOTED_SYSTEM_IDENTITY_CODE_OFFSET = 21;
    private static final int NETWORK_CONNECTION_STATUS_AVAILABLE_FLAG = 56;
    private static final int ACTIVE_NETWORK_CONNECTION_FLAG = 57;
    private static final int[] CONFIRMED_CHANNEL_PRIORITY = new int[]{58, 59, 60};
    private static final int[] ADJACENT_CHANNEL_PRIORITY = new int[]{61, 62, 63};
    private static final int[] RESERVED = new int[]{64, 65, 66, 67};
    private static final int[] VOTED_CHANNEL_NUMBER = new int[]{68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private SystemIdentityCode mVotedSystemIdentityCode;
    private List<Identifier> mIdentifiers;
    private DMRChannel mChannel;
    private AbsoluteChannelParameters mAbsoluteChannelParameters;

    public VoteNowAdvice(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public VoteNowAdvice(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, 1);
        }
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" VOTED NETWORK:").append(this.getVotedSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getVotedSystemIdentityCode().getSite());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" THIS ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        return sb.toString();
    }

    public boolean hasNetworkConnectionStatus() {
        return this.getMessage().get(56);
    }

    public boolean isActiveNetworkConnection() {
        return this.getMessage().get(57);
    }

    public int getConfirmedChannelPriority() {
        return this.getMessage().getInt(CONFIRMED_CHANNEL_PRIORITY);
    }

    public int getAdjacentChannelPriority() {
        return this.getMessage().getInt(ADJACENT_CHANNEL_PRIORITY);
    }

    public int getVotedChannelNumber() {
        return this.getMessage().getInt(VOTED_CHANNEL_NUMBER);
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    public DMRChannel getChannel() {
        if (this.hasAbsoluteChannelParameters()) {
            return this.mAbsoluteChannelParameters.getChannel();
        }
        if (this.mChannel == null) {
            this.mChannel = new DMRTier3Channel(this.getMessage().getInt(VOTED_CHANNEL_NUMBER), 1);
        }
        return this.mChannel;
    }

    public SystemIdentityCode getVotedSystemIdentityCode() {
        if (this.mVotedSystemIdentityCode == null) {
            this.mVotedSystemIdentityCode = new SystemIdentityCode(this.getMessage(), 21, false);
        }
        return this.mVotedSystemIdentityCode;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        if (this.getChannel() != null) {
            return this.getChannel().getLogicalChannelNumbers();
        }
        return new int[0];
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        if (this.getChannel() != null) {
            this.getChannel().apply(timeslotFrequencies);
        }
    }
}

