/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class LocalTime
extends Announcement {
    private static final int[] DAY = new int[]{21, 22, 23, 24, 25};
    private static final int[] MONTH = new int[]{26, 27, 28, 39};
    private static final int[] UTC = new int[]{30, 31, 32, 33, 34};
    private static final int[] HOUR = new int[]{56, 57, 58, 59, 60};
    private static final int[] MINUTE = new int[]{61, 62, 63, 64, 65, 66};
    private static final int[] SECOND = new int[]{67, 68, 69, 70, 71, 72};
    private static final int[] DAY_OF_WEEK = new int[]{73, 74, 75};
    private static final int[] UTC_MINUTES_OFFSET = new int[]{76, 77};
    private static final int[] RESERVED = new int[]{78, 79};
    private List<Identifier> mIdentifiers;

    public LocalTime(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" LOCAL TIME:").append(new Date(this.getLocalTime()).toString());
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        return sb.toString();
    }

    public long getLocalTime() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        int month = this.getMessage().getInt(MONTH);
        int day = this.getMessage().getInt(DAY);
        int utcHoursOffset = this.getMessage().getInt(UTC);
        int hour = (this.getMessage().getInt(HOUR) + (utcHoursOffset == 31 ? 0 : utcHoursOffset)) % 24;
        int minute = this.getMessage().getInt(MINUTE);
        int second = this.getMessage().getInt(SECOND);
        calendar.clear();
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTimeInMillis();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

