/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRTier3Channel;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.ArrayList;
import java.util.List;

public class AnnounceWithdrawTSCC
extends Announcement {
    private static final int[] RESERVED = new int[]{21, 22, 23, 24};
    private static final int[] COLOR_CODE_CHAN_1 = new int[]{25, 26, 27, 28};
    private static final int[] COLOR_CODE_CHAN_2 = new int[]{29, 30, 31, 32};
    private static final int ADD_WITHDRAW_CHAN_1_FLAG = 33;
    private static final int ADD_WITHDRAW_CHAN_2_FLAG = 34;
    private static final int[] CHANNEL_NUMBER_1 = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    private static final int[] CHANNEL_NUMBER_2 = new int[]{68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRChannel mChannel1;
    private DMRChannel mChannel2;
    private AbsoluteChannelParameters mAbsoluteChannelParameters;
    private List<Identifier> mIdentifiers;

    public AnnounceWithdrawTSCC(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public AnnounceWithdrawTSCC(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, 1);
        }
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasChannel1()) {
            sb.append(this.isChannel1Add() ? " ADD CHAN:" : " WITHDRAW CHAN:");
            sb.append(this.getChannel1()).append(" CC:").append(this.getChannel1ColorCode());
        }
        if (this.hasChannel2()) {
            sb.append(this.isChannel2Add() ? " ADD CHAN:" : " WITHDRAW CHAN:");
            sb.append(this.getChannel2()).append(" CC:").append(this.getChannel2ColorCode());
        }
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        return sb.toString();
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    public boolean hasChannel1() {
        return this.hasAbsoluteChannelParameters() || this.getMessage().getInt(CHANNEL_NUMBER_1) != 0;
    }

    public boolean hasChannel2() {
        return this.getMessage().getInt(CHANNEL_NUMBER_2) != 0;
    }

    public int getChannel1ColorCode() {
        if (this.hasAbsoluteChannelParameters()) {
            return this.getAbsoluteChannelParameters().getColorCode();
        }
        return this.getMessage().getInt(COLOR_CODE_CHAN_1);
    }

    public int getChannel2ColorCode() {
        return this.getMessage().getInt(COLOR_CODE_CHAN_2);
    }

    public boolean isChannel1Add() {
        return this.getMessage().get(33);
    }

    public boolean isChannel2Add() {
        return this.getMessage().get(34);
    }

    public DMRChannel getChannel1() {
        if (this.mChannel1 == null) {
            this.mChannel1 = this.hasAbsoluteChannelParameters() ? this.getAbsoluteChannelParameters().getChannel() : new DMRTier3Channel(this.getMessage().getInt(CHANNEL_NUMBER_1), 1);
        }
        return this.mChannel1;
    }

    public DMRChannel getChannel2() {
        if (this.mChannel2 == null) {
            this.mChannel2 = new DMRTier3Channel(this.getMessage().getInt(CHANNEL_NUMBER_2), 1);
        }
        return this.mChannel2;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

