/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceKind;

public abstract class Ahoy
extends CSBKMessage {
    private static final int[] SERVICE_OPTIONS_MIRROR = new int[]{16, 17, 18, 19, 20, 21, 22};
    private static final int ENCRYPTED_SERVICE_OPTION_FLAG = 17;
    protected static final int SERVICE_KIND_FLAG = 23;
    private static final int AMBIENT_LISTENING_SERVICE_FLAG = 24;
    private static final int TALKGROUP_FLAG = 25;
    protected static final int[] APPENDED_BLOCKS_OR_STATUS = new int[]{26, 27};
    private static final int[] SERVICE_KIND = new int[]{28, 29, 30, 31};
    protected static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    protected static final int[] MULTI_PURPOSE_FIELD = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private IntegerIdentifier mTargetAddress;

    public Ahoy(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public static ServiceKind getServiceKind(CorrectedBinaryMessage message) {
        return ServiceKind.fromValue(message.getInt(SERVICE_KIND));
    }

    public int getMultiPurposeFieldValue() {
        return this.getMessage().getInt(MULTI_PURPOSE_FIELD);
    }

    public ServiceKind getServiceKind() {
        return Ahoy.getServiceKind(this.getMessage());
    }

    public boolean isServiceKindFlag() {
        return this.getMessage().get(23);
    }

    public boolean isAmbientListeningServiceRequest() {
        return this.getMessage().get(24);
    }

    public IntegerIdentifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = this.isTalkgroupTarget() ? DMRTalkgroup.create(this.getMessage().getInt(TARGET_ADDRESS)) : DmrTier3Radio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public boolean isTalkgroupTarget() {
        return this.getMessage().get(25);
    }
}

