/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRTier3Channel;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.ArrayList;
import java.util.List;

public class MoveTSCC
extends CSBKMessage {
    private static final int[] RESERVED = new int[]{16, 17, 18, 19, 20, 20, 22, 23, 24};
    private static final int[] MASK = new int[]{25, 26, 27, 28, 29};
    private static final int[] RESERVED_2 = new int[]{30, 31, 32, 33, 34};
    private static final int REGISTRATION_REQUIRED_FLAG = 35;
    private static final int[] BACKOFF = new int[]{36, 37, 38, 39};
    private static final int[] RESERVED_3 = new int[]{40, 41, 42, 43};
    private static final int[] CHANNEL_NUMBER = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] RADIO = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private RadioIdentifier mRadioIdentifier;
    private DMRChannel mDMRChannel;
    private AbsoluteChannelParameters mAbsoluteChannelParameters;
    private List<Identifier> mIdentifiers;

    public MoveTSCC(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public MoveTSCC(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, 1);
        }
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" MOVE TRUNK CONTROL CHANNEL ").append(this.getChannel());
        if (this.hasRadioIdentifier()) {
            sb.append(" TO:").append(this.getRadioIdentifier());
        }
        return sb.toString();
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    public DMRChannel getChannel() {
        if (this.mDMRChannel == null) {
            this.mDMRChannel = this.hasAbsoluteChannelParameters() ? this.getAbsoluteChannelParameters().getChannel() : new DMRTier3Channel(this.getMessage().getInt(CHANNEL_NUMBER), 1);
        }
        return this.mDMRChannel;
    }

    public int getMask() {
        return this.getMessage().getInt(MASK);
    }

    public RadioIdentifier getRadioIdentifier() {
        if (this.mRadioIdentifier == null) {
            this.mRadioIdentifier = DmrTier3Radio.createTo(this.getMessage().getInt(RADIO));
        }
        return this.mRadioIdentifier;
    }

    public boolean hasRadioIdentifier() {
        return this.getMessage().getInt(RADIO) != 0;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasRadioIdentifier()) {
                this.mIdentifiers.add(this.getRadioIdentifier());
            }
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }
}

