/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusTalkgroupAffiliation
extends CSBKMessage {
    private static final int[] RADIO = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] TALKGROUP = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] UNKNOWN = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mRadio;
    private TalkgroupIdentifier mTalkgroup;

    public ConnectPlusTalkgroupAffiliation(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ AFFILIATE RADIO:").append(this.getRadio());
        sb.append(" TO TALKGROUP:").append(this.getTalkgroup());
        sb.append(" UNK:").append(this.getUnknown());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public int getUnknown() {
        return this.getMessage().getInt(UNKNOWN);
    }

    public RadioIdentifier getRadio() {
        if (this.mRadio == null) {
            this.mRadio = DMRRadio.createFrom(this.getMessage().getInt(RADIO));
        }
        return this.mRadio;
    }

    public TalkgroupIdentifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(TALKGROUP));
        }
        return this.mTalkgroup;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getRadio());
            this.mIdentifiers.add(this.getTalkgroup());
        }
        return this.mIdentifiers;
    }
}

